/* Copyright (C) 1995,1996,1997,2000,2001,2002,2003 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <http://www.gnu.org/licenses/>.  */

#ifndef _SYS_SHM_H
# error "Never include <bits/shm.h> directly; use <sys/shm.h> instead."
#endif

#include <bits/types.h>

/* Permission flag for shmget.  */
#define SHM_R		0400		/* or S_IRUGO from <linux/stat.h> */
#define SHM_W		0200		/* or S_IWUGO from <linux/stat.h> */

/* Flags for `shmat'.  */
#define SHM_RDONLY	010000		/* attach read-only else read-write */
#define SHM_RND		020000		/* round attach address to SHMLBA */
#define SHM_REMAP	040000		/* take-over region on attach */

/* Commands for `shmctl'.  */
#define SHM_LOCK	11		/* lock segment (root only) */
#define SHM_UNLOCK	12		/* unlock segment (root only) */

/* Segment low boundary address multiple.  */
#define SHMLBA		0x40000


/* Type to count number of attaches.  */
typedef unsigned long int shmatt_t;

/* Data structure describing a set of semaphores.  */
struct shmid_ds
  {
    struct ipc_perm shm_perm;		/* operation permission struct */
    size_t shm_segsz;			/* size of segment in bytes */
#if (__WORDSIZE == 32) && defined(__UCLIBC_USE_TIME64__)
    unsigned long int shm_atime_internal_1;		/* time of last shmat() */
    unsigned long int shm_dtime_internal_1;		/* time of last shmdt() */
    unsigned long int shm_ctime_internal_1;		/* time of last change by shmctl() */
#else
    __time_t shm_atime;
    __time_t shm_dtime;
    __time_t shm_ctime;
#endif
    __pid_t shm_cpid;			/* pid of creator */
    __pid_t shm_lpid;			/* pid of last shmop */
    shmatt_t shm_nattch;		/* number of current attaches */
#if (__WORDSIZE == 32) && defined(__UCLIBC_USE_TIME64__)
    unsigned short int shm_atime_internal_2;		/* time of last shmat() */
    unsigned short int shm_dtime_internal_2;		/* time of last shmdt() */
    unsigned short int shm_ctime_internal_2;		/* time of last change by shmctl() */
    unsigned short int __uclibc_unused1;
    __time_t shm_atime;
    __time_t shm_dtime;
    __time_t shm_ctime;
#else
    unsigned short int __uclibc_unused1;
    unsigned short int __uclibc_unused2;
    unsigned short int __uclibc_unused3;
    unsigned short int __uclibc_unused4;
#endif
  };

#ifdef __USE_MISC

/* ipcs ctl commands */
# define SHM_STAT	13
# define SHM_INFO	14

/* shm_mode upper byte flags */
# define SHM_DEST	01000	/* segment will be destroyed on last detach */
# define SHM_LOCKED	02000   /* segment will not be swapped */
# define SHM_HUGETLB	04000	/* segment is mapped via hugetlb */

struct shminfo
  {
    unsigned long int shmmax;
    unsigned long int shmmin;
    unsigned long int shmmni;
    unsigned long int shmseg;
    unsigned long int shmall;
    unsigned long int __uclibc_unused1;
    unsigned long int __uclibc_unused2;
    unsigned long int __uclibc_unused3;
    unsigned long int __uclibc_unused4;
  };

struct shm_info
  {
    int used_ids;
    unsigned long int shm_tot;  /* total allocated shm */
    unsigned long int shm_rss;  /* total resident shm */
    unsigned long int shm_swp;  /* total swapped shm */
    unsigned long int swap_attempts;
    unsigned long int swap_successes;
  };

#endif /* __USE_MISC */
